var ContactListItem = new Class({
  owner: null,
  info: null,
	open: false,
	options: {
    class_name: "contact_list_item",
    id_prefix: "contact_list_item_"
  },
	
	initialize: function(o, info, open){
		this.owner = o;
		this.info = new Hash();
		this.load(info);
		this.open = open;
		
		var tpl = new Template("contact_list_item");
    this.el = new Element('div').adopt(tpl.xml).getFirst();
		
		if (this.open) {
			this.el.getElement('.body').removeClass('hidden');
		} else {
			this.el.getElement('.body').addClass('hidden');
		}
		
		this.el.getElement('a.remove').addEvent('click', function(){
			this.owner.user.removeContact(this.info.id);
		}.bind(this));
		
		this.el.getElement('a.history').addEvent('click', function(){		
			if (this.owner.user.info.anonymous) {
				showMessage('Neregistrovaní používatelia nemôžu zobrazovať históriu konverzácií.');
				return;
	  	}
			this.owner.user.showContactHistory(this.info.id);
		}.bind(this));
		
		this.el.getElement('a.cprofile').addEvent('click', function(){
			this.owner.user.showContactProfile(this.info.id);
		}.bind(this));
		
		this.el.getElement('.header').addEvent('click', function(){
      var b = this.el.getElement('.body');
			if(!this.open){
				b.removeClass('hidden');
			} else {
				b.addClass('hidden');
			}		
			this.open = !this.open;
    }.bind(this));
		
		this.el.getElement('.header').addEvent('dblclick', function(e){
      e.stop();
			this.owner.user.startConversation(this.info.id);
    }.bind(this));
	},
	
	load: function(info){
		this.info = info;
		return this;
	},
	
	setContentEls: function(){
		$each(this.info, function(value, key){
			var el = this.el.getElement('.'+key);			
			if($defined(el)) el.set('text', value);
			
			if($defined(el) && (key == 'email')){
				el.getParent().setProperty('href', 'mailto:'+value);
			}
		}.bind(this));
		
		// update status
		this.el.getElement('.status').set('text', '').removeClass('offline').removeClass('online').addClass((this.info.status) ? 'online' : 'offline');
	},
	
	getEl: function(){
		this.setContentEls();
		return this.el.setProperty('id', this.options.id_prefix + this.info.id);
	}
});

ContactListItem.implement(new Options);